clear
close all
clc

%% synthetic image

A = zeros(40,40)+0.1;
A(5:15,10:15) = 0.6;
for i = 20:30
    for j = 25:35
        if (i-25)^2+(j-30)^2<=5^2
            A(i,j)=0.8;
        end
    end
end

figure; imagesc(A); colormap gray

%%
labels = image_seg(A,3,4,0.1);

%% real image
close all

A = imread('elephant.jpg');
%A = imread('goat.jpg');
figure; imagesc(A); colormap gray

A = rgb2gray(A);
A = double(A);
A = A/max(max(A));
[m, n] = size(A);

samplingRate = 8;
B = zeros(floor(m/samplingRate),floor(n/samplingRate));
for i = samplingRate:samplingRate:m
    for j = samplingRate:samplingRate:n
        B(i/samplingRate,j/samplingRate) = mean(mean(A(i-samplingRate+1:i, j-samplingRate+1:j)));
    end
end

figure; imagesc(B); colormap gray

%%

labels = image_seg(B, 4, 5, .08);
